/****************************************************************************
*
*               Audio Framework
*               ---------------
*
****************************************************************************
*     ModTutorialBiquadSmoothed.h
****************************************************************************
*
*     Description:  Multichannel Biquad filter
*
*     Copyright:    2019 DSP Concepts, Inc. All rights reserved.
*                   3235 Kifer Road
*                   Santa Clara, CA 95054
*
***************************************************************************/

/**
 * @addtogroup Modules
 * @{
 */

/**
 * @file
 * @brief Multichannel Biquad filter
 */

#ifndef _MOD_TUTORIALBIQUADSMOOTHED_H
#define _MOD_TUTORIALBIQUADSMOOTHED_H

#include "ModCommon.h"
#include "MathHelper.h"

#define MASK_TutorialBiquadSmoothed_smoothingTime 0x00000100
#define MASK_TutorialBiquadSmoothed_smoothingCoeff 0x00000200
#define MASK_TutorialBiquadSmoothed_coeffs 0x00000400
#define MASK_TutorialBiquadSmoothed_currentCoeffs 0x00000800
#define MASK_TutorialBiquadSmoothed_state 0x00001000
#define OFFSET_TutorialBiquadSmoothed_smoothingTime 0x00000008
#define OFFSET_TutorialBiquadSmoothed_smoothingCoeff 0x00000009
#define OFFSET_TutorialBiquadSmoothed_coeffs 0x0000000A
#define OFFSET_TutorialBiquadSmoothed_currentCoeffs 0x0000000B
#define OFFSET_TutorialBiquadSmoothed_state 0x0000000C

#define CLASSID_TUTORIALBIQUADSMOOTHED (CLASS_ID_MODBASE + 60002)

#ifdef __cplusplus
extern "C" {
#endif

// ----------------------------------------------------------------------
// Overall instance class
// ----------------------------------------------------------------------

typedef struct _awe_modTutorialBiquadSmoothedInstance
{
    ModuleInstanceDescriptor instance;
    FLOAT32            smoothingTime;       // Time constant of the smoothing process.
    FLOAT32            smoothingCoeff;      // Smoothing coefficient. This is computed based on the smoothingTime, sample rate, and block size of the module.
    FLOAT32*           coeffs;              // Filter coefficients [b0; b1; b2; a1; a2]
    FLOAT32*           currentCoeffs;       // Smoothed filter coefficients [b0; b1; b2; a1; a2]
    FLOAT32*           state;               // State variables. 2 per channel.
} awe_modTutorialBiquadSmoothedInstance;

#if !defined(NOREDEF)
extern const ModClassModule awe_modTutorialBiquadSmoothedClass;
#endif // #if !defined(NOREDEF)

/* Dynamic instantiation is used by default.  When building for static
** code, define AWE_STATIC_CODE to eliminate the constructor function. */

#ifndef AWE_STATIC_CODE
ModInstanceDescriptor * awe_modTutorialBiquadSmoothedConstructor(INT32 * FW_RESTRICT retVal, UINT32 nIO, WireInstance ** FW_RESTRICT pWires, size_t argCount, const Sample * FW_RESTRICT args);
#endif // #ifndef AWE_STATIC_CODE


void awe_modTutorialBiquadSmoothedProcess(void *pInstance);

UINT32 awe_modTutorialBiquadSmoothedSet(void *pInstance, UINT32 mask);
 



#ifdef __cplusplus
}
#endif


#endif // _MOD_TUTORIALBIQUADSMOOTHED_H

/**
 * @}
 *
 * End of file.
 */
