/****************************************************************************
*
*               Audio Framework
*               ---------------
*
****************************************************************************
*     ModTutorialBiquadMono.c
****************************************************************************
*
*     Description:  Mono Biquad filter
*
*     Copyright:    2019 DSP Concepts, Inc. All rights reserved.
*                   3235 Kifer Road
*                   Santa Clara, CA 95054
*
***************************************************************************/

/**
 * @addtogroup Modules
 * @{
 */

/**
 * @file
 * @brief Mono Biquad filter
 */

#define NOREDEF


#include "Framework.h"
#include "Errors.h"
#include "ModTutorialBiquadMono.h"


#ifdef __cplusplus
extern "C" {
#endif

/* ----------------------------------------------------------------------
** THIS IS AN AUTO-GENERATED FILE. Please make all changes in the inner file. 
** Changes made to this file will be overwritten during module generation.
** Audio module class object.  This describes the audio module to the
** framework.  It contains pointers to functions and number of
** variables.
** ------------------------------------------------------------------- */

CREATE_MODULE_CLASS(Class_awe_modTutorialBiquadMono, (7 + 0))

AWE_MOD_SLOW_ANY_CONST
const Class_awe_modTutorialBiquadMono awe_modTutorialBiquadMonoClass =
{
    {
        { NULL, CLASSID_TUTORIALBIQUADMONO, },
        awe_modTutorialBiquadMonoProcess,                // Processing function
        IOMatchUpModule_Bypass,                 // Bypass function
        0,                                    // Set function
        0,                                    // Get function
        0,				                      // Unused field
        ClassModule_PackArgCounts(7, 0),    // (Public words, private words)
        {0x0000007F, 0x00000000}, // Specifies which variables are floating-point
    },
#ifdef BUILD64
    {
        offsetof(awe_modTutorialBiquadMonoInstance, b0),
        offsetof(awe_modTutorialBiquadMonoInstance, b1),
        offsetof(awe_modTutorialBiquadMonoInstance, b2),
        offsetof(awe_modTutorialBiquadMonoInstance, a1),
        offsetof(awe_modTutorialBiquadMonoInstance, a2),
        offsetof(awe_modTutorialBiquadMonoInstance, wNm1),
        offsetof(awe_modTutorialBiquadMonoInstance, wNm2),
    }
#endif
};


/* ----------------------------------------------------------------------
** Memory allocation function.  This is required because the module
** requires additional memory outside of its instance structure.
** ------------------------------------------------------------------- */


/* ----------------------------------------------------------------------
** Real-time Processing function.
** ------------------------------------------------------------------- */

AWE_MOD_FAST_CODE
void awe_modTutorialBiquadMonoProcess(void *pInstance)
{
    awe_modTutorialBiquadMonoInstance *S = (awe_modTutorialBiquadMonoInstance *)pInstance;
    WireInstance **pWires = ClassModule_GetWires(S);
    INT32 blockSize = ClassWire_GetBlockSize(pWires[0]);
    INT32 n;
    FLOAT32 wN, wNm1, wNm2;
    FLOAT32 b0, b1, b2, a1, a2;
    FLOAT32 *src, *dst;
    
    src = (FLOAT32 *) pWires[0]->buffer;
    dst = (FLOAT32 *) pWires[1]->buffer;
    
    // Pull out module variables into local registers
    b0 = S->b0;
    b1 = S->b1;
    b2 = S->b2;
    a1 = -S->a1;
    a2 = -S->a2;
    wNm1 = S->wNm1;
    wNm2 = S->wNm2;
    
    for(n = 0; n < blockSize; n++)
    {
        wN = (a1*wNm1) + (a2*wNm2) + (*src);
        *dst =  (b0*wN) + (b1*wNm1) + (b2*wNm2);
        wNm2 = wNm1;
        wNm1 = wN;
    
        src++;
        dst++;
    }
    
    S->wNm1 = wNm1;
    S->wNm2 = wNm2;
    
}




#ifdef __cplusplus
}
#endif

/**
 * @}
 *
 * End of file.
 */
