function PASS = test_tutorial_biquad_smoothed(M)
% PASS = test_tutorial_biquad_smoothed(M)
% Performs a standard set of regression tests for this module.
%
% PASS = test_tutorial_biquad_smoothed(M)
% Tests the specific instance of the module M.
%
% Copyright (c) 2007-2020 DSP Concepts, Inc. All Rights Reserved.

% Set random number generator to default settings for repeatable results.

awe_rng('default');

minSNR = 120;
NUMBLOCKS = 16;

if (nargin == 0)
    PASS = 1;
    for numChannels = [1 3 4 6 8]
        for blockSize = [1 2 32 255]
            for smoothingTime = [0 1 10 100 1000]
                % Test with a second order lowpass filter
                [b, a] = butter(2, 0.1);
                C = [b a(2:3)].';
                
                PTIN = {new_pin_type(numChannels, blockSize)};
                PTOUT = {new_pin_type(numChannels, blockSize)};
                
                MUT = tutorial_biquad_smoothed_module('MUT');
                MUT.smoothingTime = smoothingTime;
                
                MUT.coeffs = C;
                
                POSTBUILD = {sprintf('SYS.MUT.currentCoeffs = SYS.MUT.currentCoeffs * 0;')};
                pass = test_server_vs_matlab(MUT, PTIN, PTOUT, NUMBLOCKS, minSNR, POSTBUILD);
                
                PASS = (pass && PASS);
                if (PASS == 0)
                    break;
                end
            end
            if (PASS == 0)
                break;
            end
        end
        if (PASS == 0)
            break;
        end
    end
else
    PASS = test_server_vs_matlab(M, {}, {}, NUMBLOCKS, minSNR);
end

return;
