ModuleTutorialBiquadMono 0xBEEFF260, BaseModule

{

    b0                      float      // First numerator coefficient
    b1                      float      // Second numerator coefficient
    b2                      float      // Third numerator coefficient
    a1                      float      // Second denominator coefficient
    a2                      float      // Third denominator coefficient
    wNm1                    float      // First state variable
    wNm2                    float      // Second state variable
}

ModuleTutorialBiquad 0xBEEFF261, BaseModule

{

    b0                      float      // First numerator coefficient
    b1                      float      // Second numerator coefficient
    b2                      float      // Third numerator coefficient
    a1                      float      // Second denominator coefficient
    a2                      float      // Third denominator coefficient
    state                   *float     // State variables. 2 per channel.
}

ModuleTutorialBiquadSmoothed 0xBEEFF262, BaseModule

{

    smoothingTime           float      // Time constant of the smoothing process.
    smoothingCoeff          float      // Smoothing coefficient. This is computed based on the smoothingTime, sample rate, and block size of the module.
    coeffs                  *float     // Filter coefficients [b0; b1; b2; a1; a2]
    currentCoeffs           *float     // Smoothed filter coefficients [b0; b1; b2; a1; a2]
    state                   *float     // State variables. 2 per channel.
}

ModuleTutorialPeakingFilter 0xBEEFF263, BaseModule

{

    freq                    float      // Cutoff frequency of the filter, in Hz
    gain                    float      // Amount of boost or cut to apply
    Q                       float      // Specifies the Q of the filter
    smoothingTime           float      // Time constant of the smoothing process
    smoothingCoeff          float      // Smoothing coefficient. This is computed based on the smoothingTime, sample rate, and block size of the module
    coeffs                  *float     // Filter coefficients [b0; b1; b2; a1; a2]
    currentCoeffs           *float     // Smoothed filter coefficients [b0; b1; b2; a1; a2]
    state                   *float     // State variables. 2 per channel.
}

