awe_modTutorialBiquadInstance *S = (awe_modTutorialBiquadInstance *)pInstance;
WireInstance **pWires = ClassModule_GetWires(S);
INT32 blockSize = ClassWire_GetBlockSize(pWires[0]);
INT32 numChannels = ClassWire_GetChannelCount(pWires[0]);
INT32 n;
INT32 chan;
FLOAT32 wN, wNm1, wNm2;
FLOAT32 b0, b1, b2, a1, a2;
FLOAT32 *src, *dst;

// Pull out module variables into local registers
b0 = S->b0;
b1 = S->b1;
b2 = S->b2;
a1 = -S->a1;
a2 = -S->a2;

for(chan = 0; chan < numChannels; chan++)
{
    src = ((FLOAT32 *) pWires[0]->buffer) + chan;
    dst = ((FLOAT32 *) pWires[1]->buffer) + chan;

    wNm1 = S->state[2*chan + 0];
    wNm2 = S->state[2*chan + 1];

    for(n = 0; n < blockSize; n++)
    {
        wN = (a1*wNm1) + (a2*wNm2) + (*src);
        *dst =  (b0*wN) + (b1*wNm1) + (b2*wNm2);
        wNm2 = wNm1;
        wNm1 = wN;

        src += numChannels;
        dst += numChannels;
    }

    S->state[2*chan + 0] = wNm1;
    S->state[2*chan + 1] = wNm2;
}

