function PASS = test_tutorial_peaking_filter(M)
% PASS = test_tutorial_peaking_filter(M)
% Performs a standard set of regression tests for this module.
%
% PASS = test_tutorial_peaking_filter(M)
% Tests the specific instance of the module M.
%
% Copyright (c) 2007-2020 DSP Concepts, Inc. All Rights Reserved.

% Set random number generator to default settings for repeatable results.

awe_rng('default');

minSNR = 80;
NUMBLOCKS = 16;

index = 1;

FQG = [100 1 5; 250 0.5 -6; 1000 3 9; 8000 2 -4];

if (nargin == 0)
    PASS = 1;
    for numChannels = [1 3 4 6 8]
        for blockSize = [1 2 32 255]
            for smoothingTime = [0 1 10 100 1000]
                PTIN = {new_pin_type(numChannels, blockSize)};
                PTOUT = {new_pin_type(numChannels, blockSize)};
                
                MUT = tutorial_peaking_filter_module('MUT');
                MUT.smoothingTime = smoothingTime;

                fqg = FQG(index, :);
                index = index + 1;
                if (index > size(FQG, 1))
                    index = 1;
                end
                MUT.freq = fqg(1);
                MUT.Q = fqg(2);
                MUT.gain = fqg(3);

                POSTBUILD = {sprintf('SYS.MUT.currentCoeffs = SYS.MUT.currentCoeffs * 0;')};
                pass = test_server_vs_matlab(MUT, PTIN, PTOUT, NUMBLOCKS, minSNR, POSTBUILD);
                
                PASS = (pass && PASS);
                if (PASS == 0)
                    break;
                end
            end
            if (PASS == 0)
                break;
            end
        end
        if (PASS == 0)
            break;
        end
    end
else
    PASS = test_server_vs_matlab(M, {}, {}, NUMBLOCKS, minSNR);
end

return;
