/* ----------------------------------------------------------------------------
 *	 Preprocessor Definitions
 * ------------------------------------------------------------------------- */
#ifndef AKM_TARGET_PROCESSOR_H_
#define AKM_TARGET_PROCESSOR_H_

#include "xtensa/core-macros.h"
#include "StandardDefs.h"

/* The AWE user interrupt number. */
#define AWE_INTNUM 17

/** The AWE user interrupt mask. */
#define AWE_INTMASK (1<<AWE_INTNUM)

#define FW_RESTRICT

#define VEC_RESTRICT	__restrict__
#define VEC_INLINE		__inline__

#ifndef __ALIGN_BEGIN  
	#define __ALIGN_BEGIN
#endif
    
#ifndef __ALIGN_END
	#define __ALIGN_END __attribute__ ((aligned (4)))
#endif 

/* ----------------------------------------------------------------------
** Interrupts
** ------------------------------------------------------------------- */
#define DISABLE_INTERRUPTS() _xtos_ints_off(AWE_INTMASK)
#define ENABLE_INTERRUPTS() _xtos_ints_on(AWE_INTMASK)

/* ----------------------------------------------------------------------
** Cycle counting macros
** ------------------------------------------------------------------- */
#define GET_CCOUNT() ( { int __ccount; \
				__asm__ volatile("rsr.ccount %0" : "=a"(__ccount)); \
				__ccount; } )


/* ----------------------------------------------------------------------
** awe_fwCycleInit
** ------------------------------------------------------------------- */
static VEC_INLINE void awe_fwCycleInit(void)
{
}


/* ----------------------------------------------------------------------
** awe_fwGetCycles
** ------------------------------------------------------------------- */
static VEC_INLINE UINT32 awe_fwGetCycles(void)
{
	return GET_CCOUNT();
}

/* ----------------------------------------------------------------------
** awe_fwElapsedCycles
** ------------------------------------------------------------------- */
static VEC_INLINE UINT32 awe_fwElapsedCycles(UINT32 start_time, UINT32 end_time)
{
    UINT elapsedTime;

	if (end_time > start_time)
	{
		elapsedTime = end_time - start_time;
	}
	else
	{
		elapsedTime = ((((UINT32)0xFFFFFFFF) - start_time) + end_time + 1);
	}

	return elapsedTime;
}

#endif	  /* AKM_TARGET_PROCESSOR_H_ */
