awe_modTutorialPeakingFilterInstance *S = (awe_modTutorialPeakingFilterInstance *) pInstance;
WireInstance **pWires = ClassModule_GetWires(S);
FLOAT32 sampleRate = ClassWire_GetSampleRate(pWires[0]);
INT32 blockSize = ClassWire_GetBlockSize(pWires[0]);
FLOAT32 A, alpha, w0;
FLOAT32 b0, b1, b2, a0, a1, a2;
    
// Compute the filter coefficients based on {freq, gain, Q}
// Taken from Audio-EQ-Cookbook.txt, by Robert Bristow-Johnson
    
if (mask & (MASK_TutorialPeakingFilter_freq | MASK_TutorialPeakingFilter_gain | MASK_TutorialPeakingFilter_Q))
{
    w0 = 6.283185307179586f * S->freq / sampleRate;
    A = undb20f(S->gain * 0.5f);
    
    if (S->Q >= 0)
    {
        alpha = sinf(w0) / (2.0f * S->Q);
    }
    else
    {
        alpha = sinf(w0) * sinhf((logf(2.0f)/2.0f)*(-S->Q)*w0/sinf(w0));
    }
    
    b0 =   1.0f + alpha*A;
    b1 =  -2.0f * cosf(w0);
    b2 =   1.0f - alpha*A;
    a0 =   1.0f + alpha/A;
    a1 =  -2.0f * cosf(w0);
    a2 =   1.0f - alpha/A;
     
    // Normalize so that the a0 coefficient equals 1.0
    S->coeffs[0] = b0 / a0;
    S->coeffs[1] = b1 / a0;
    S->coeffs[2] = b2 / a0;
    S->coeffs[3] = a1 / a0;
    S->coeffs[4] = a2 / a0;
}
    
// Compute the smoothing coefficient based on the smoothingTime
if (mask & MASK_TutorialPeakingFilter_smoothingTime)
{
    S->smoothingCoeff = 1.0f - expf(-1.0f/((sampleRate / blockSize) * 0.001f * S->smoothingTime));    
}
    
return 0;