/****************************************************************************
*
*               Audio Framework
*               ---------------
*
****************************************************************************
*     ModTutorialBiquad.h
****************************************************************************
*
*     Description:  Multichannel Biquad filter
*
*     Copyright:    2019 DSP Concepts, Inc. All rights reserved.
*                   3235 Kifer Road
*                   Santa Clara, CA 95054
*
***************************************************************************/

/**
 * @addtogroup Modules
 * @{
 */

/**
 * @file
 * @brief Multichannel Biquad filter
 */

#ifndef _MOD_TUTORIALBIQUAD_H
#define _MOD_TUTORIALBIQUAD_H

#include "ModCommon.h"
#include "MathHelper.h"

#define MASK_TutorialBiquad_b0 0x00000100
#define MASK_TutorialBiquad_b1 0x00000200
#define MASK_TutorialBiquad_b2 0x00000400
#define MASK_TutorialBiquad_a1 0x00000800
#define MASK_TutorialBiquad_a2 0x00001000
#define MASK_TutorialBiquad_state 0x00002000
#define OFFSET_TutorialBiquad_b0 0x00000008
#define OFFSET_TutorialBiquad_b1 0x00000009
#define OFFSET_TutorialBiquad_b2 0x0000000A
#define OFFSET_TutorialBiquad_a1 0x0000000B
#define OFFSET_TutorialBiquad_a2 0x0000000C
#define OFFSET_TutorialBiquad_state 0x0000000D

#define CLASSID_TUTORIALBIQUAD (CLASS_ID_MODBASE + 60001)

#ifdef __cplusplus
extern "C" {
#endif

// ----------------------------------------------------------------------
// Overall instance class
// ----------------------------------------------------------------------

typedef struct _awe_modTutorialBiquadInstance
{
    ModuleInstanceDescriptor instance;
    FLOAT32            b0;                  // First numerator coefficient
    FLOAT32            b1;                  // Second numerator coefficient
    FLOAT32            b2;                  // Third numerator coefficient
    FLOAT32            a1;                  // Second denominator coefficient
    FLOAT32            a2;                  // Third denominator coefficient
    FLOAT32*           state;               // State variables. 2 per channel.
} awe_modTutorialBiquadInstance;

#if !defined(NOREDEF)
extern const ModClassModule awe_modTutorialBiquadClass;
#endif // #if !defined(NOREDEF)

/* Dynamic instantiation is used by default.  When building for static
** code, define AWE_STATIC_CODE to eliminate the constructor function. */

#ifndef AWE_STATIC_CODE
ModInstanceDescriptor * awe_modTutorialBiquadConstructor(INT32 * FW_RESTRICT retVal, UINT32 nIO, WireInstance ** FW_RESTRICT pWires, size_t argCount, const Sample * FW_RESTRICT args);
#endif // #ifndef AWE_STATIC_CODE


void awe_modTutorialBiquadProcess(void *pInstance);

 



#ifdef __cplusplus
}
#endif


#endif // _MOD_TUTORIALBIQUAD_H

/**
 * @}
 *
 * End of file.
 */
