awe_modTutorialBiquadMonoInstance *S = (awe_modTutorialBiquadMonoInstance *)pInstance;
WireInstance **pWires = ClassModule_GetWires(S);
INT32 blockSize = ClassWire_GetBlockSize(pWires[0]);
INT32 n;
FLOAT32 wN, wNm1, wNm2;
FLOAT32 b0, b1, b2, a1, a2;
FLOAT32 *src, *dst;

src = (FLOAT32 *) pWires[0]->buffer;
dst = (FLOAT32 *) pWires[1]->buffer;

// Pull out module variables into local registers
b0 = S->b0;
b1 = S->b1;
b2 = S->b2;
a1 = -S->a1;
a2 = -S->a2;
wNm1 = S->wNm1;
wNm2 = S->wNm2;

for(n = 0; n < blockSize; n++)
{
    wN = (a1*wNm1) + (a2*wNm2) + (*src);
    *dst =  (b0*wN) + (b1*wNm1) + (b2*wNm2);
    wNm2 = wNm1;
    wNm1 = wN;

    src++;
    dst++;
}

S->wNm1 = wNm1;
S->wNm2 = wNm2;

