/****************************************************************************
*
*               Audio Framework
*               ---------------
*
****************************************************************************
*     ModTutorialBiquadMono.h
****************************************************************************
*
*     Description:  Mono Biquad filter
*
*     Copyright:    2019 DSP Concepts, Inc. All rights reserved.
*                   3235 Kifer Road
*                   Santa Clara, CA 95054
*
***************************************************************************/

/**
 * @addtogroup Modules
 * @{
 */

/**
 * @file
 * @brief Mono Biquad filter
 */

#ifndef _MOD_TUTORIALBIQUADMONO_H
#define _MOD_TUTORIALBIQUADMONO_H

#include "ModCommon.h"
#include "MathHelper.h"

#define MASK_TutorialBiquadMono_b0 0x00000100
#define MASK_TutorialBiquadMono_b1 0x00000200
#define MASK_TutorialBiquadMono_b2 0x00000400
#define MASK_TutorialBiquadMono_a1 0x00000800
#define MASK_TutorialBiquadMono_a2 0x00001000
#define MASK_TutorialBiquadMono_wNm1 0x00002000
#define MASK_TutorialBiquadMono_wNm2 0x00004000
#define OFFSET_TutorialBiquadMono_b0 0x00000008
#define OFFSET_TutorialBiquadMono_b1 0x00000009
#define OFFSET_TutorialBiquadMono_b2 0x0000000A
#define OFFSET_TutorialBiquadMono_a1 0x0000000B
#define OFFSET_TutorialBiquadMono_a2 0x0000000C
#define OFFSET_TutorialBiquadMono_wNm1 0x0000000D
#define OFFSET_TutorialBiquadMono_wNm2 0x0000000E

#define CLASSID_TUTORIALBIQUADMONO (CLASS_ID_MODBASE + 60000)

#ifdef __cplusplus
extern "C" {
#endif

// ----------------------------------------------------------------------
// Overall instance class
// ----------------------------------------------------------------------

typedef struct _awe_modTutorialBiquadMonoInstance
{
    ModuleInstanceDescriptor instance;
    FLOAT32            b0;                  // First numerator coefficient
    FLOAT32            b1;                  // Second numerator coefficient
    FLOAT32            b2;                  // Third numerator coefficient
    FLOAT32            a1;                  // Second denominator coefficient
    FLOAT32            a2;                  // Third denominator coefficient
    FLOAT32            wNm1;                // First state variable
    FLOAT32            wNm2;                // Second state variable
    
} awe_modTutorialBiquadMonoInstance;

#if !defined(NOREDEF)
extern const ModClassModule awe_modTutorialBiquadMonoClass;
#endif // #if !defined(NOREDEF)

/* Dynamic instantiation is used by default.  When building for static
** code, define AWE_STATIC_CODE to eliminate the constructor function. */

#ifndef AWE_STATIC_CODE
// This points the constructor for this class to the base constructor
#define awe_modTutorialBiquadMonoConstructor(ARG1, ARG2, ARG3, ARG4, ARG5) ClassModule_Constructor(CLASSID_TUTORIALBIQUADMONO, ARG1, ARG2, ARG3, ARG4, ARG5)
#endif // #ifndef AWE_STATIC_CODE


void awe_modTutorialBiquadMonoProcess(void *pInstance);

 



#ifdef __cplusplus
}
#endif


#endif // _MOD_TUTORIALBIQUADMONO_H

/**
 * @}
 *
 * End of file.
 */
