function PASS = test_tutorial_biquad_mono(M)
% PASS = test_tutorial_biquad_mono(M)
% Performs a standard set of regression tests for this module.
%
% PASS = test_tutorial_biquad_mono(M)
% Tests the specific instance of the module M.
%
% Copyright (c) 2007-2020 DSP Concepts, Inc. All Rights Reserved.

% Set random number generator to default settings for repeatable results.

awe_rng('default');

minSNR = 120;
NUMBLOCKS = 16;

if (nargin == 0)
    PASS = 1;
    % Test with a second order lowpass filter
    [b, a] = butter(2, 0.1);
    
    for blockSize = [1 2 7 32 255 318]
        PTIN = {new_pin_type(1, blockSize)};
        PTOUT = {new_pin_type(1, blockSize)};

        MUT = tutorial_biquad_mono_module('MUT');
        MUT.b0 = b(1);
        MUT.b1 = b(2);
        MUT.b2 = b(3);
        MUT.a1 = a(2);
        MUT.a2 = a(3);
        
        pass = test_server_vs_matlab(MUT, PTIN, PTOUT, NUMBLOCKS, minSNR);

        PASS = (pass && PASS);
        if (PASS == 0)
            break;
        end
    end
else
    PASS = test_server_vs_matlab(M, {}, {}, NUMBLOCKS, minSNR);
end  

return;    
