function M= tutorial_module(NAME)
% M = tutorial_module(NAME)
% Copies input pin data to the output pin.
%
% Arguments:
% NAME - name of the module
%

% AudioWeaverModule [This tag makes it appear under awe_help]

M=awe_module('Tutorial', 'Copies input wire to output wire');
if (nargin == 0)
 return;
end

M.name=NAME;
M.defaultName='Tutorial';

% Add input and output pins with no data or size restrictions
PT=new_pin_type([], [], [], '*32', []);
add_pin(M, 'input', 'in', 'Input signal', PT);
add_pin(M, 'output', 'out', 'Output signal', PT);

% ----------------------------------------------------------------------
% Code generation details
% ----------------------------------------------------------------------
awe_addcodemarker(M, 'processFunction', 'Insert:\InnerTutorial_Process.c');
awe_addcodemarker(M, 'discussion', {'Copies the input to the output. '});

% ----------------------------------------------------------------------
% Module browser information
% ----------------------------------------------------------------------
M.moduleBrowser.path = 'Third Party';
M.moduleBrowser.image = '../images/Tutorial.bmp';
M.moduleBrowser.searchTags = 'pass thru through copy';
return;
