/****************************************************************************
*
*               Audio Framework
*               ---------------
*
****************************************************************************
*     ModTutorialBiquad.c
****************************************************************************
*
*     Description:  Multichannel Biquad filter
*
*     Copyright:    2019 DSP Concepts, Inc. All rights reserved.
*                   3235 Kifer Road
*                   Santa Clara, CA 95054
*
***************************************************************************/

/**
 * @addtogroup Modules
 * @{
 */

/**
 * @file
 * @brief Multichannel Biquad filter
 */

#define NOREDEF


#include "Framework.h"
#include "Errors.h"
#include "ModTutorialBiquad.h"


#ifdef __cplusplus
extern "C" {
#endif

/* ----------------------------------------------------------------------
** THIS IS AN AUTO-GENERATED FILE. Please make all changes in the inner file. 
** Changes made to this file will be overwritten during module generation.
** Audio module class object.  This describes the audio module to the
** framework.  It contains pointers to functions and number of
** variables.
** ------------------------------------------------------------------- */

CREATE_MODULE_CLASS(Class_awe_modTutorialBiquad, (5 + 1))

AWE_MOD_SLOW_ANY_CONST
const Class_awe_modTutorialBiquad awe_modTutorialBiquadClass =
{
    {
        { awe_modTutorialBiquadConstructor, CLASSID_TUTORIALBIQUAD, },
        awe_modTutorialBiquadProcess,                // Processing function
        IOMatchUpModule_Bypass,                 // Bypass function
        0,                                    // Set function
        0,                                    // Get function
        0,				                      // Unused field
        ClassModule_PackArgCounts(5, 1),    // (Public words, private words)
        {0x0000003F, 0x00000000}, // Specifies which variables are floating-point
    },
#ifdef BUILD64
    {
        offsetof(awe_modTutorialBiquadInstance, b0),
        offsetof(awe_modTutorialBiquadInstance, b1),
        offsetof(awe_modTutorialBiquadInstance, b2),
        offsetof(awe_modTutorialBiquadInstance, a1),
        offsetof(awe_modTutorialBiquadInstance, a2),
        offsetof(awe_modTutorialBiquadInstance, state),
    }
#endif
};


/* ----------------------------------------------------------------------
** Memory allocation function.  This is required because the module
** requires additional memory outside of its instance structure.
** ------------------------------------------------------------------- */

AWE_MOD_SLOW_CODE
ModInstanceDescriptor *awe_modTutorialBiquadConstructor(INT32 * FW_RESTRICT retVal, UINT32 nIO, WireInstance ** FW_RESTRICT pWires, size_t argCount, const Sample * FW_RESTRICT args)
{   
	awe_modTutorialBiquadInstance *S = (awe_modTutorialBiquadInstance *) BaseClassModule_Constructor((ModClassModule *) &awe_modTutorialBiquadClass, retVal, nIO, pWires, argCount, args);
	
	// Check if BaseClassModule_Constructor() finished properly.  If not,
	// the error code is in *retVal
	if (S == NULL)
	{
	    return 0;
	}
	
    if ((S->state = (FLOAT32 *) awe_fwMalloc(ClassWire_GetChannelCount(pWires[0]) * 2 * sizeof(FLOAT32), AWE_HEAP_FAST2SLOW, retVal)) == 0)            
    {            
        // Error code is in *retVal            
        return 0;            
    }            
                
                
    return ((ModInstanceDescriptor *) S);            

    
}

/* ----------------------------------------------------------------------
** Real-time Processing function.
** ------------------------------------------------------------------- */

AWE_MOD_FAST_CODE
void awe_modTutorialBiquadProcess(void *pInstance)
{
    awe_modTutorialBiquadInstance *S = (awe_modTutorialBiquadInstance *)pInstance;
    WireInstance **pWires = ClassModule_GetWires(S);
    INT32 blockSize = ClassWire_GetBlockSize(pWires[0]);
    INT32 numChannels = ClassWire_GetChannelCount(pWires[0]);
    INT32 n;
    INT32 chan;
    FLOAT32 wN, wNm1, wNm2;
    FLOAT32 b0, b1, b2, a1, a2;
    FLOAT32 *src, *dst;
    
    // Pull out module variables into local registers
    b0 = S->b0;
    b1 = S->b1;
    b2 = S->b2;
    a1 = -S->a1;
    a2 = -S->a2;
    
    for(chan = 0; chan < numChannels; chan++)
    {
        src = ((FLOAT32 *) pWires[0]->buffer) + chan;
        dst = ((FLOAT32 *) pWires[1]->buffer) + chan;
    
        wNm1 = S->state[2*chan + 0];
        wNm2 = S->state[2*chan + 1];
    
        for(n = 0; n < blockSize; n++)
        {
            wN = (a1*wNm1) + (a2*wNm2) + (*src);
            *dst =  (b0*wN) + (b1*wNm1) + (b2*wNm2);
            wNm2 = wNm1;
            wNm1 = wN;
    
            src += numChannels;
            dst += numChannels;
        }
    
        S->state[2*chan + 0] = wNm1;
        S->state[2*chan + 1] = wNm2;
    }
    
}




#ifdef __cplusplus
}
#endif

/**
 * @}
 *
 * End of file.
 */
