/****************************************************************************
*
*               Audio Framework
*               ---------------
*
****************************************************************************
*     ModTutorial.h
****************************************************************************
*
*     Description:  Copies input wire to output wire
*
*     Copyright:    2019 DSP Concepts, Inc. All rights reserved.
*                   3235 Kifer Road
*                   Santa Clara, CA 95054
*
***************************************************************************/

/**
 * @addtogroup Modules
 * @{
 */

/**
 * @file
 * @brief Copies input wire to output wire
 */

#ifndef _MOD_TUTORIAL_H
#define _MOD_TUTORIAL_H

#include "ModCommon.h"
#include "MathHelper.h"


#define CLASSID_TUTORIAL (CLASS_ID_MODBASE + 60001)

#ifdef __cplusplus
extern "C" {
#endif

// ----------------------------------------------------------------------
// Overall instance class
// ----------------------------------------------------------------------

typedef struct _awe_modTutorialInstance
{
    ModuleInstanceDescriptor instance;
    
    
} awe_modTutorialInstance;

#if !defined(NOREDEF)
extern const ModClassModule awe_modTutorialClass;
#endif // #if !defined(NOREDEF)

/* Dynamic instantiation is used by default.  When building for static
** code, define AWE_STATIC_CODE to eliminate the constructor function. */

#ifndef AWE_STATIC_CODE
// This points the constructor for this class to the base constructor
#define awe_modTutorialConstructor(ARG1, ARG2, ARG3, ARG4, ARG5) ClassModule_Constructor(CLASSID_TUTORIAL, ARG1, ARG2, ARG3, ARG4, ARG5)
#endif // #ifndef AWE_STATIC_CODE


void awe_modTutorialProcess(void *pInstance);

 



#ifdef __cplusplus
}
#endif


#endif // _MOD_TUTORIAL_H

/**
 * @}
 *
 * End of file.
 */
