function [M, WIRE_OUT] = tutorial_biquad_mono_process(M, WIRE_IN)
% [M, WIRE_OUT] = tutorial_biquad_mono_process(M, WIRE_IN)
% Processing function for the tutorial_biquad_mono_module.m.  Arguments:
%   M - @awe_module object.
%   WIRE_IN - cell array of input wires.
% The function returns the updated module object and a cell array of
% output wires.

% Copyright 2020.  DSP Concepts, Inc.  All Rights Reserved.

IN = WIRE_IN{1};
[blockSize, ~] = size(IN);

b0 = M.b0;
b1 = M.b1;
b2 = M.b2;
a1 = -M.a1;
a2 = -M.a2;

wNm1 = M.wNm1;
wNm2 = M.wNm2;

OUT = zeros(blockSize, 1);

for i = 1:blockSize
    wN = a1*wNm1 + a2*wNm2 + IN(i);
    OUT(i)= b0*wN + b1*wNm1 + b2*wNm2;
    wNm2 = wNm1;
    wNm1 = wN;
end

M.wNm1 = wNm1;
M.wNm2 = wNm2;

WIRE_OUT{1} = OUT;

return;
